/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.compatskills.common.compats.minecraft.item.harvestlevel;

import codersafterdark.reskillable.api.requirement.Requirement;
import codersafterdark.reskillable.api.requirement.RequirementComparision;
import codersafterdark.reskillable.api.requirement.RequirementException;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class HarvestLevelRequirement
extends Requirement {
    private final int harvestLevel;

    public HarvestLevelRequirement(int level) {
        this.harvestLevel = level;
        this.tooltip = TextFormatting.GRAY + " - " + new TextComponentTranslation("compatskills.requirements.format.harvest_level", new Object[]{"%s", this.harvestLevel}).func_150261_e();
    }

    public static HarvestLevelRequirement fromString(String input) throws RequirementException {
        if (input.isEmpty()) {
            throw new RequirementException("No harvest level given.");
        }
        try {
            return new HarvestLevelRequirement(Integer.parseInt(input));
        }
        catch (NumberFormatException e) {
            throw new RequirementException("Invalid harvest level '" + input + "'.");
        }
    }

    public boolean achievedByPlayer(EntityPlayer player) {
        return this.hasHarvestLevel(player.func_184614_ca()) || this.hasHarvestLevel(player.func_184592_cb());
    }

    public RequirementComparision matches(Requirement o) {
        if (o instanceof HarvestLevelRequirement) {
            HarvestLevelRequirement other = (HarvestLevelRequirement)o;
            if (this.harvestLevel == other.harvestLevel) {
                return RequirementComparision.EQUAL_TO;
            }
            return this.harvestLevel > other.harvestLevel ? RequirementComparision.GREATER_THAN : RequirementComparision.LESS_THAN;
        }
        return RequirementComparision.NOT_EQUAL;
    }

    private boolean hasHarvestLevel(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        return item.getToolClasses(stack).stream().anyMatch(toolClass -> item.getHarvestLevel(stack, toolClass, null, null) >= this.harvestLevel);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof HarvestLevelRequirement && this.harvestLevel == ((HarvestLevelRequirement)((Object)o)).harvestLevel;
    }

    public int hashCode() {
        return Objects.hash(this.harvestLevel);
    }
}

